﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="HotAirStationProfileList.ascx.vb" Inherits="Web.HotAirStationProfileList"%>
<%@ Import Namespace="Helpers" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>
<%@ Register Src="~/private/stations/HotAirStation/Sections/HotAirStationProfileView.ascx" TagName="cu_profileview" TagPrefix="uc" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelSliderPerfiles" UpdateMode="Conditional">
    <ContentTemplate>

        <div class="mode-panel nomarginbottom">

            <div class="holder">
                <uc:cu_controlmode ID="cu_controlmode" runat="server" Visible="false" />
                <ul id="stationPortList" class="pagination" runat="server">
                    <asp:Repeater ID="RepeaterPorts" runat="server" OnItemCommand="RepeaterPortsItemCommand">
                        <ItemTemplate>
                            <li class='<%# Eval("State")%>'>
                                <asp:LinkButton ID="BtnPuerto" runat="server" CommandArgument='<%# Eval("PortNumber")%>' Visible='<%# Eval("Active")%>'><%# Eval("PortNumber")%></asp:LinkButton>
                            </li>
                        </ItemTemplate>
                    </asp:Repeater>
                </ul>
            </div>

            <!-- controles ocultos-->
            <asp:HiddenField ID="hdnPortActivo" runat="server" Value="1" />
            <asp:HiddenField ID="hdnNumPuertos" runat="server" />

        </div>

    </ContentTemplate>
</asp:UpdatePanel>

<asp:UpdatePanel runat="server" ID="UpdatePanelContentPerfiles" UpdateMode="Conditional">
<ContentTemplate>

     <!-- listado de perfiles -->
    <div id="stationProfileList" class="item-ajax-holder profile" runat="server" visible="False">

        <div class="mode-panel">
            <div class="holder">
                <div class="title-panel">
					<ul class="filters">
						<li> 
                            <asp:LinkButton ID="btnProfileFilter" OnClick="btnProfileAction_Click" runat="server" CssClass="name" CommandName="FILTER">Importar</asp:LinkButton>
                            <asp:TextBox ID="tbxName" runat="server" placeholder="Nombre"></asp:TextBox>
						</li>
					</ul>
					<ul class="actions">
						<li><asp:LinkButton ID="btnProfileImport" OnClick="btnProfileAction_Click" runat="server" CssClass="import" CommandName="IMPORT">Importar</asp:LinkButton></li>							
						<li style="display:none;"><asp:LinkButton ID="btnProfileUndo" OnClick="btnProfileAction_Click" runat="server" CssClass="undo" CommandName="UNDO">Deshacer</asp:LinkButton></li>
						<li><asp:LinkButton ID="btnProfileNew" OnClick="btnProfileAction_Click" runat="server" CssClass="new" CommandName="NEW">Nuevo</asp:LinkButton></li>
						<li><asp:LinkButton ID="btnProfileDuplicate" OnClick="btnProfileAction_Click" runat="server" CssClass="duplicate" CommandName="DUPLICATE">Duplicar</asp:LinkButton></li>
						<li><asp:LinkButton ID="btnProfileDelete" OnClick="btnProfileAction_Click" runat="server" CssClass="delete" CommandName="DELETE">Borrar</asp:LinkButton></li>
					</ul>
				</div>
            </div>
        </div>
        
        <!-- lista de perfiles -->
        <div class="list">
		    <div class="mask">
			    <div class="slideset">
                    <div class="jcf-scrollable">
			            <asp:Repeater ID="RepeaterProfiles" runat="server">
                        <ItemTemplate>
				        <div class="col slide">
					        <div class="img-holder">
						        <div class="menu-profile">
                                    <asp:CheckBox ID='checkProfileAction' OnCheckedChanged="chkProfileAction_CheckedChanged" runat="server" CommandName="CHECK" CommandArgument='<%# Eval("ProfileName")%>' Checked="false" Enabled="true" AutoPostBack="true" /> 
                                    <asp:LinkButton ID="btnProfileEdit1" OnClick="btnProfileAction_Click" runat="server" CssClass="edit" CommandName="EDIT" CommandArgument='<%#Eval("ProfileName")%>'>Editar</asp:LinkButton>
						        </div>
                                <asp:LinkButton ID="btnProfileEdit2" OnClick="btnProfileAction_Click" runat="server" CssClass="desc" CommandName="EDIT" CommandArgument='<%#Eval("ProfileName")%>'>
							        <div class="header">
								        <h2><%#Eval("ProfileName")%></h2>
								        <ol class="ports">
									        <li class="active"></li>
									        <li></li>
									        <li class="active"></li>
									        <li class="active"></li>
								        </ol>
								        <div class="text-holder">
									        <span class="duration"><%#Eval("ProfileDuration")%></span>
									        <span class="mode">Ext.Temp</span>
								        </div>
							        </div>
                                    <%--<img id="imgProfile" runat="server" src='<%#Me.Page.ResolveUrl(BaseProfileThumbnailPath) & Eval("ProfileThumbnailFileName")%>' alt='<%#Eval("ProfileName")%>'/>--%>
							        <img src='<%#Me.Page.ResolveUrl("~/Services/ImageService.ashx?id=") & Eval("ProfileThumbnailFileName")%>' alt='<%#Eval("ProfileName")%>'/>
                                </asp:LinkButton>
					        </div>						
				        </div>
                        </ItemTemplate>
			            </asp:Repeater> 			
                    </div>
                </div>
            </div>
		</div>

    </div>        

    <!-- edición de perfil -->
    <div id="stationProfileEdit" class="item-ajax-holder profile" runat="server" visible="False">

        <div class="edit" >
            <uc:cu_profileview ID="cu_profileview" runat="server"/>		
        </div>

    </div>

</ContentTemplate>
</asp:UpdatePanel>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderSliderPerfiles" TargetControlID="UpdatePanelSliderPerfiles" BehaviorID="animation" runat="server">
    <Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="LockScreen(); initRefreshFunctions($('div.ajax-holder')); $('div.menu-herramientas').data('ScrollGallery').currentStep = currentstyle_menuherramientas; $('div.menu-herramientas div.slideset').attr('style', currentstyle_menuherramientas); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderContentPerfiles" TargetControlID="UpdatePanelContentPerfiles" BehaviorID="animation" runat="server">
    <Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<asp:UpdateProgress ID="UpdateProgressContentPerfiles" runat="server" AssociatedUpdatePanelID="UpdatePanelContentPerfiles" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>
